package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationMetric(
    f1Score: Optional[Float] = Optional.Absent,
    precision: Optional[Float] = Optional.Absent,
    recall: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.EvaluationMetric = {
    import EvaluationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.EvaluationMetric
      .builder()
      .optionallyWith(f1Score.map(value => value: java.lang.Float))(_.f1Score)
      .optionallyWith(precision.map(value => value: java.lang.Float))(
        _.precision
      )
      .optionallyWith(recall.map(value => value: java.lang.Float))(_.recall)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.EvaluationMetric.ReadOnly =
    zio.aws.textract.model.EvaluationMetric.wrap(buildAwsValue())
}
object EvaluationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.EvaluationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.EvaluationMetric =
      zio.aws.textract.model.EvaluationMetric(
        f1Score.map(value => value),
        precision.map(value => value),
        recall.map(value => value)
      )
    def f1Score: Optional[Float]
    def precision: Optional[Float]
    def recall: Optional[Float]
    def getF1Score: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("f1Score", f1Score)
    def getPrecision: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("precision", precision)
    def getRecall: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("recall", recall)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.EvaluationMetric
  ) extends zio.aws.textract.model.EvaluationMetric.ReadOnly {
    override val f1Score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.f1Score())
      .map(value => value: Float)
    override val precision: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.precision())
      .map(value => value: Float)
    override val recall: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.recall())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.EvaluationMetric
  ): zio.aws.textract.model.EvaluationMetric.ReadOnly = new Wrapper(impl)
}
