package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.AdapterId
import scala.jdk.CollectionConverters._
final case class DeleteAdapterRequest(adapterId: AdapterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DeleteAdapterRequest = {
    import DeleteAdapterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DeleteAdapterRequest
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DeleteAdapterRequest.ReadOnly =
    zio.aws.textract.model.DeleteAdapterRequest.wrap(buildAwsValue())
}
object DeleteAdapterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DeleteAdapterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DeleteAdapterRequest =
      zio.aws.textract.model.DeleteAdapterRequest(adapterId)
    def adapterId: AdapterId
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DeleteAdapterRequest
  ) extends zio.aws.textract.model.DeleteAdapterRequest.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DeleteAdapterRequest
  ): zio.aws.textract.model.DeleteAdapterRequest.ReadOnly = new Wrapper(impl)
}
