package zio.aws.textract.model
import zio.aws.textract.model.primitives.{
  AdapterVersionStatusMessage,
  AdapterId,
  TagValue,
  DateTime,
  AdapterVersion,
  KMSKeyId,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetAdapterVersionResponse(
    adapterId: Optional[AdapterId] = Optional.Absent,
    adapterVersion: Optional[AdapterVersion] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    featureTypes: Optional[Iterable[zio.aws.textract.model.FeatureType]] =
      Optional.Absent,
    status: Optional[zio.aws.textract.model.AdapterVersionStatus] =
      Optional.Absent,
    statusMessage: Optional[AdapterVersionStatusMessage] = Optional.Absent,
    datasetConfig: Optional[
      zio.aws.textract.model.AdapterVersionDatasetConfig
    ] = Optional.Absent,
    kmsKeyId: Optional[KMSKeyId] = Optional.Absent,
    outputConfig: Optional[zio.aws.textract.model.OutputConfig] =
      Optional.Absent,
    evaluationMetrics: Optional[
      Iterable[zio.aws.textract.model.AdapterVersionEvaluationMetric]
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse = {
    import GetAdapterVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        adapterVersion.map(value =>
          AdapterVersion.unwrap(value): java.lang.String
        )
      )(_.adapterVersion)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          AdapterVersionStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(datasetConfig.map(value => value.buildAwsValue()))(
        _.datasetConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        evaluationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationMetrics)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly =
    zio.aws.textract.model.GetAdapterVersionResponse.wrap(buildAwsValue())
}
object GetAdapterVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetAdapterVersionResponse =
      zio.aws.textract.model.GetAdapterVersionResponse(
        adapterId.map(value => value),
        adapterVersion.map(value => value),
        creationTime.map(value => value),
        featureTypes.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        datasetConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value),
        outputConfig.map(value => value.asEditable),
        evaluationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def adapterVersion: Optional[AdapterVersion]
    def creationTime: Optional[DateTime]
    def featureTypes: Optional[List[zio.aws.textract.model.FeatureType]]
    def status: Optional[zio.aws.textract.model.AdapterVersionStatus]
    def statusMessage: Optional[AdapterVersionStatusMessage]
    def datasetConfig
        : Optional[zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly]
    def kmsKeyId: Optional[KMSKeyId]
    def outputConfig: Optional[zio.aws.textract.model.OutputConfig.ReadOnly]
    def evaluationMetrics: Optional[
      List[zio.aws.textract.model.AdapterVersionEvaluationMetric.ReadOnly]
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAdapterVersion: ZIO[Any, AwsError, AdapterVersion] =
      AwsError.unwrapOptionField("adapterVersion", adapterVersion)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFeatureTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.FeatureType]] =
      AwsError.unwrapOptionField("featureTypes", featureTypes)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.textract.model.AdapterVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, AdapterVersionStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getDatasetConfig: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly
    ] = AwsError.unwrapOptionField("datasetConfig", datasetConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getEvaluationMetrics: ZIO[Any, AwsError, List[
      zio.aws.textract.model.AdapterVersionEvaluationMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationMetrics", evaluationMetrics)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse
  ) extends zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val adapterVersion: Optional[AdapterVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adapterVersion())
        .map(value => zio.aws.textract.model.primitives.AdapterVersion(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val featureTypes
        : Optional[List[zio.aws.textract.model.FeatureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.FeatureType.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.textract.model.AdapterVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.textract.model.AdapterVersionStatus.wrap(value))
    override val statusMessage: Optional[AdapterVersionStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.textract.model.primitives.AdapterVersionStatusMessage(value)
        )
    override val datasetConfig: Optional[
      zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetConfig())
      .map(value =>
        zio.aws.textract.model.AdapterVersionDatasetConfig.wrap(value)
      )
    override val kmsKeyId: Optional[KMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.textract.model.primitives.KMSKeyId(value))
    override val outputConfig
        : Optional[zio.aws.textract.model.OutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value => zio.aws.textract.model.OutputConfig.wrap(value))
    override val evaluationMetrics: Optional[
      List[zio.aws.textract.model.AdapterVersionEvaluationMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.AdapterVersionEvaluationMetric.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.textract.model.primitives
              .TagKey(key) -> zio.aws.textract.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterVersionResponse
  ): zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
