package zio.aws.textract.model
import zio.aws.textract.model.primitives.{
  AdapterName,
  AdapterId,
  TagValue,
  DateTime,
  AdapterDescription,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetAdapterResponse(
    adapterId: Optional[AdapterId] = Optional.Absent,
    adapterName: Optional[AdapterName] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    description: Optional[AdapterDescription] = Optional.Absent,
    featureTypes: Optional[Iterable[zio.aws.textract.model.FeatureType]] =
      Optional.Absent,
    autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetAdapterResponse = {
    import GetAdapterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetAdapterResponse
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        adapterName.map(value => AdapterName.unwrap(value): java.lang.String)
      )(_.adapterName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        description.map(value =>
          AdapterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .optionallyWith(autoUpdate.map(value => value.unwrap))(_.autoUpdate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetAdapterResponse.ReadOnly =
    zio.aws.textract.model.GetAdapterResponse.wrap(buildAwsValue())
}
object GetAdapterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetAdapterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetAdapterResponse =
      zio.aws.textract.model.GetAdapterResponse(
        adapterId.map(value => value),
        adapterName.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        featureTypes.map(value => value),
        autoUpdate.map(value => value),
        tags.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def adapterName: Optional[AdapterName]
    def creationTime: Optional[DateTime]
    def description: Optional[AdapterDescription]
    def featureTypes: Optional[List[zio.aws.textract.model.FeatureType]]
    def autoUpdate: Optional[zio.aws.textract.model.AutoUpdate]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAdapterName: ZIO[Any, AwsError, AdapterName] =
      AwsError.unwrapOptionField("adapterName", adapterName)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, AdapterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFeatureTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.FeatureType]] =
      AwsError.unwrapOptionField("featureTypes", featureTypes)
    def getAutoUpdate: ZIO[Any, AwsError, zio.aws.textract.model.AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterResponse
  ) extends zio.aws.textract.model.GetAdapterResponse.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val adapterName: Optional[AdapterName] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterName())
      .map(value => zio.aws.textract.model.primitives.AdapterName(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val description: Optional[AdapterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.textract.model.primitives.AdapterDescription(value)
        )
    override val featureTypes
        : Optional[List[zio.aws.textract.model.FeatureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.FeatureType.wrap(item)
          }.toList
        )
    override val autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoUpdate())
        .map(value => zio.aws.textract.model.AutoUpdate.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.textract.model.primitives
              .TagKey(key) -> zio.aws.textract.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterResponse
  ): zio.aws.textract.model.GetAdapterResponse.ReadOnly = new Wrapper(impl)
}
