package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdapterVersionEvaluationMetric(
    baseline: Optional[zio.aws.textract.model.EvaluationMetric] =
      Optional.Absent,
    adapterVersion: Optional[zio.aws.textract.model.EvaluationMetric] =
      Optional.Absent,
    featureType: Optional[zio.aws.textract.model.FeatureType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric = {
    import AdapterVersionEvaluationMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric
      .builder()
      .optionallyWith(baseline.map(value => value.buildAwsValue()))(_.baseline)
      .optionallyWith(adapterVersion.map(value => value.buildAwsValue()))(
        _.adapterVersion
      )
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.AdapterVersionEvaluationMetric.ReadOnly =
    zio.aws.textract.model.AdapterVersionEvaluationMetric.wrap(buildAwsValue())
}
object AdapterVersionEvaluationMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AdapterVersionEvaluationMetric =
      zio.aws.textract.model.AdapterVersionEvaluationMetric(
        baseline.map(value => value.asEditable),
        adapterVersion.map(value => value.asEditable),
        featureType.map(value => value)
      )
    def baseline: Optional[zio.aws.textract.model.EvaluationMetric.ReadOnly]
    def adapterVersion
        : Optional[zio.aws.textract.model.EvaluationMetric.ReadOnly]
    def featureType: Optional[zio.aws.textract.model.FeatureType]
    def getBaseline
        : ZIO[Any, AwsError, zio.aws.textract.model.EvaluationMetric.ReadOnly] =
      AwsError.unwrapOptionField("baseline", baseline)
    def getAdapterVersion
        : ZIO[Any, AwsError, zio.aws.textract.model.EvaluationMetric.ReadOnly] =
      AwsError.unwrapOptionField("adapterVersion", adapterVersion)
    def getFeatureType: ZIO[Any, AwsError, zio.aws.textract.model.FeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric
  ) extends zio.aws.textract.model.AdapterVersionEvaluationMetric.ReadOnly {
    override val baseline
        : Optional[zio.aws.textract.model.EvaluationMetric.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseline())
        .map(value => zio.aws.textract.model.EvaluationMetric.wrap(value))
    override val adapterVersion
        : Optional[zio.aws.textract.model.EvaluationMetric.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adapterVersion())
        .map(value => zio.aws.textract.model.EvaluationMetric.wrap(value))
    override val featureType: Optional[zio.aws.textract.model.FeatureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureType())
        .map(value => zio.aws.textract.model.FeatureType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AdapterVersionEvaluationMetric
  ): zio.aws.textract.model.AdapterVersionEvaluationMetric.ReadOnly =
    new Wrapper(impl)
}
