package zio.aws.textract.model
import zio.aws.textract.model.primitives.{DateTime, AdapterName, AdapterId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AdapterOverview(
    adapterId: Optional[AdapterId] = Optional.Absent,
    adapterName: Optional[AdapterName] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    featureTypes: Optional[Iterable[zio.aws.textract.model.FeatureType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AdapterOverview = {
    import AdapterOverview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AdapterOverview
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        adapterName.map(value => AdapterName.unwrap(value): java.lang.String)
      )(_.adapterName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AdapterOverview.ReadOnly =
    zio.aws.textract.model.AdapterOverview.wrap(buildAwsValue())
}
object AdapterOverview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AdapterOverview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AdapterOverview =
      zio.aws.textract.model.AdapterOverview(
        adapterId.map(value => value),
        adapterName.map(value => value),
        creationTime.map(value => value),
        featureTypes.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def adapterName: Optional[AdapterName]
    def creationTime: Optional[DateTime]
    def featureTypes: Optional[List[zio.aws.textract.model.FeatureType]]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAdapterName: ZIO[Any, AwsError, AdapterName] =
      AwsError.unwrapOptionField("adapterName", adapterName)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFeatureTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.FeatureType]] =
      AwsError.unwrapOptionField("featureTypes", featureTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AdapterOverview
  ) extends zio.aws.textract.model.AdapterOverview.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val adapterName: Optional[AdapterName] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterName())
      .map(value => zio.aws.textract.model.primitives.AdapterName(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val featureTypes
        : Optional[List[zio.aws.textract.model.FeatureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.FeatureType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AdapterOverview
  ): zio.aws.textract.model.AdapterOverview.ReadOnly = new Wrapper(impl)
}
