package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ExpenseDocument(
    expenseIndex: Optional[UInteger] = Optional.Absent,
    summaryFields: Optional[Iterable[zio.aws.textract.model.ExpenseField]] =
      Optional.Absent,
    lineItemGroups: Optional[Iterable[zio.aws.textract.model.LineItemGroup]] =
      Optional.Absent,
    blocks: Optional[Iterable[zio.aws.textract.model.Block]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseDocument = {
    import ExpenseDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseDocument
      .builder()
      .optionallyWith(
        expenseIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.expenseIndex)
      .optionallyWith(
        summaryFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryFields)
      .optionallyWith(
        lineItemGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineItemGroups)
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseDocument.ReadOnly =
    zio.aws.textract.model.ExpenseDocument.wrap(buildAwsValue())
}
object ExpenseDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseDocument =
      zio.aws.textract.model.ExpenseDocument(
        expenseIndex.map(value => value),
        summaryFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lineItemGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def expenseIndex: Optional[UInteger]
    def summaryFields
        : Optional[List[zio.aws.textract.model.ExpenseField.ReadOnly]]
    def lineItemGroups
        : Optional[List[zio.aws.textract.model.LineItemGroup.ReadOnly]]
    def blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]]
    def getExpenseIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("expenseIndex", expenseIndex)
    def getSummaryFields: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseField.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryFields", summaryFields)
    def getLineItemGroups: ZIO[Any, AwsError, List[
      zio.aws.textract.model.LineItemGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("lineItemGroups", lineItemGroups)
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDocument
  ) extends zio.aws.textract.model.ExpenseDocument.ReadOnly {
    override val expenseIndex: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.expenseIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val summaryFields
        : Optional[List[zio.aws.textract.model.ExpenseField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaryFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.ExpenseField.wrap(item)
          }.toList
        )
    override val lineItemGroups
        : Optional[List[zio.aws.textract.model.LineItemGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineItemGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.LineItemGroup.wrap(item)
          }.toList
        )
    override val blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Block.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDocument
  ): zio.aws.textract.model.ExpenseDocument.ReadOnly = new Wrapper(impl)
}
