package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.JobId
import scala.jdk.CollectionConverters._
final case class StartLendingAnalysisResponse(
    jobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse = {
    import StartLendingAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly =
    zio.aws.textract.model.StartLendingAnalysisResponse.wrap(buildAwsValue())
}
object StartLendingAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.StartLendingAnalysisResponse =
      zio.aws.textract.model
        .StartLendingAnalysisResponse(jobId.map(value => value))
    def jobId: Optional[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse
  ) extends zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.textract.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.StartLendingAnalysisResponse
  ): zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly = new Wrapper(
    impl
  )
}
