package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{StatusMessage, PaginationToken}
import scala.jdk.CollectionConverters._
final case class GetLendingAnalysisResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    jobStatus: Optional[zio.aws.textract.model.JobStatus] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    results: Optional[Iterable[zio.aws.textract.model.LendingResult]] =
      Optional.Absent,
    warnings: Optional[Iterable[zio.aws.textract.model.Warning]] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    analyzeLendingModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse = {
    import GetLendingAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        analyzeLendingModelVersion.map(value => value: java.lang.String)
      )(_.analyzeLendingModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly =
    zio.aws.textract.model.GetLendingAnalysisResponse.wrap(buildAwsValue())
}
object GetLendingAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetLendingAnalysisResponse =
      zio.aws.textract.model.GetLendingAnalysisResponse(
        documentMetadata.map(value => value.asEditable),
        jobStatus.map(value => value),
        nextToken.map(value => value),
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value),
        analyzeLendingModelVersion.map(value => value)
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def jobStatus: Optional[zio.aws.textract.model.JobStatus]
    def nextToken: Optional[PaginationToken]
    def results: Optional[List[zio.aws.textract.model.LendingResult.ReadOnly]]
    def warnings: Optional[List[zio.aws.textract.model.Warning.ReadOnly]]
    def statusMessage: Optional[StatusMessage]
    def analyzeLendingModelVersion: Optional[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.textract.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.textract.model.LendingResult.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getAnalyzeLendingModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "analyzeLendingModelVersion",
        analyzeLendingModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse
  ) extends zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val jobStatus: Optional[zio.aws.textract.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.textract.model.JobStatus.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
    override val results
        : Optional[List[zio.aws.textract.model.LendingResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.LendingResult.wrap(item)
          }.toList
        )
    override val warnings
        : Optional[List[zio.aws.textract.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Warning.wrap(item)
          }.toList
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.textract.model.primitives.StatusMessage(value))
    override val analyzeLendingModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzeLendingModelVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetLendingAnalysisResponse
  ): zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly = new Wrapper(
    impl
  )
}
