package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LendingResult(
    page: Optional[UInteger] = Optional.Absent,
    pageClassification: Optional[zio.aws.textract.model.PageClassification] =
      Optional.Absent,
    extractions: Optional[Iterable[zio.aws.textract.model.Extraction]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.LendingResult = {
    import LendingResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.LendingResult
      .builder()
      .optionallyWith(page.map(value => UInteger.unwrap(value): Integer))(
        _.page
      )
      .optionallyWith(pageClassification.map(value => value.buildAwsValue()))(
        _.pageClassification
      )
      .optionallyWith(
        extractions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extractions)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.LendingResult.ReadOnly =
    zio.aws.textract.model.LendingResult.wrap(buildAwsValue())
}
object LendingResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.LendingResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.LendingResult =
      zio.aws.textract.model.LendingResult(
        page.map(value => value),
        pageClassification.map(value => value.asEditable),
        extractions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def page: Optional[UInteger]
    def pageClassification
        : Optional[zio.aws.textract.model.PageClassification.ReadOnly]
    def extractions: Optional[List[zio.aws.textract.model.Extraction.ReadOnly]]
    def getPage: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("page", page)
    def getPageClassification: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.PageClassification.ReadOnly
    ] = AwsError.unwrapOptionField("pageClassification", pageClassification)
    def getExtractions
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Extraction.ReadOnly]] =
      AwsError.unwrapOptionField("extractions", extractions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.LendingResult
  ) extends zio.aws.textract.model.LendingResult.ReadOnly {
    override val page: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val pageClassification
        : Optional[zio.aws.textract.model.PageClassification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageClassification())
        .map(value => zio.aws.textract.model.PageClassification.wrap(value))
    override val extractions
        : Optional[List[zio.aws.textract.model.Extraction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extractions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Extraction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.LendingResult
  ): zio.aws.textract.model.LendingResult.ReadOnly = new Wrapper(impl)
}
