package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LendingField(
    `type`: Optional[String] = Optional.Absent,
    keyDetection: Optional[zio.aws.textract.model.LendingDetection] =
      Optional.Absent,
    valueDetections: Optional[
      Iterable[zio.aws.textract.model.LendingDetection]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.LendingField = {
    import LendingField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.LendingField
      .builder()
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(keyDetection.map(value => value.buildAwsValue()))(
        _.keyDetection
      )
      .optionallyWith(
        valueDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.valueDetections)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.LendingField.ReadOnly =
    zio.aws.textract.model.LendingField.wrap(buildAwsValue())
}
object LendingField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.LendingField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.LendingField =
      zio.aws.textract.model.LendingField(
        `type`.map(value => value),
        keyDetection.map(value => value.asEditable),
        valueDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: Optional[String]
    def keyDetection: Optional[zio.aws.textract.model.LendingDetection.ReadOnly]
    def valueDetections
        : Optional[List[zio.aws.textract.model.LendingDetection.ReadOnly]]
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getKeyDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.LendingDetection.ReadOnly] =
      AwsError.unwrapOptionField("keyDetection", keyDetection)
    def getValueDetections: ZIO[Any, AwsError, List[
      zio.aws.textract.model.LendingDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("valueDetections", valueDetections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.LendingField
  ) extends zio.aws.textract.model.LendingField.ReadOnly {
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val keyDetection
        : Optional[zio.aws.textract.model.LendingDetection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyDetection())
        .map(value => zio.aws.textract.model.LendingDetection.wrap(value))
    override val valueDetections
        : Optional[List[zio.aws.textract.model.LendingDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueDetections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.LendingDetection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.LendingField
  ): zio.aws.textract.model.LendingField.ReadOnly = new Wrapper(impl)
}
