package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DocumentGroup(
    `type`: Optional[NonEmptyString] = Optional.Absent,
    splitDocuments: Optional[Iterable[zio.aws.textract.model.SplitDocument]] =
      Optional.Absent,
    detectedSignatures: Optional[
      Iterable[zio.aws.textract.model.DetectedSignature]
    ] = Optional.Absent,
    undetectedSignatures: Optional[
      Iterable[zio.aws.textract.model.UndetectedSignature]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DocumentGroup = {
    import DocumentGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DocumentGroup
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        splitDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.splitDocuments)
      .optionallyWith(
        detectedSignatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detectedSignatures)
      .optionallyWith(
        undetectedSignatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.undetectedSignatures)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DocumentGroup.ReadOnly =
    zio.aws.textract.model.DocumentGroup.wrap(buildAwsValue())
}
object DocumentGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DocumentGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DocumentGroup =
      zio.aws.textract.model.DocumentGroup(
        `type`.map(value => value),
        splitDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        detectedSignatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        undetectedSignatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: Optional[NonEmptyString]
    def splitDocuments
        : Optional[List[zio.aws.textract.model.SplitDocument.ReadOnly]]
    def detectedSignatures
        : Optional[List[zio.aws.textract.model.DetectedSignature.ReadOnly]]
    def undetectedSignatures
        : Optional[List[zio.aws.textract.model.UndetectedSignature.ReadOnly]]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getSplitDocuments: ZIO[Any, AwsError, List[
      zio.aws.textract.model.SplitDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("splitDocuments", splitDocuments)
    def getDetectedSignatures: ZIO[Any, AwsError, List[
      zio.aws.textract.model.DetectedSignature.ReadOnly
    ]] = AwsError.unwrapOptionField("detectedSignatures", detectedSignatures)
    def getUndetectedSignatures: ZIO[Any, AwsError, List[
      zio.aws.textract.model.UndetectedSignature.ReadOnly
    ]] =
      AwsError.unwrapOptionField("undetectedSignatures", undetectedSignatures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DocumentGroup
  ) extends zio.aws.textract.model.DocumentGroup.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.textract.model.primitives.NonEmptyString(value))
    override val splitDocuments
        : Optional[List[zio.aws.textract.model.SplitDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.splitDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.SplitDocument.wrap(item)
          }.toList
        )
    override val detectedSignatures
        : Optional[List[zio.aws.textract.model.DetectedSignature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectedSignatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.DetectedSignature.wrap(item)
          }.toList
        )
    override val undetectedSignatures
        : Optional[List[zio.aws.textract.model.UndetectedSignature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.undetectedSignatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.UndetectedSignature.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DocumentGroup
  ): zio.aws.textract.model.DocumentGroup.ReadOnly = new Wrapper(impl)
}
