package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ExpenseField(
    `type`: Optional[zio.aws.textract.model.ExpenseType] = Optional.Absent,
    labelDetection: Optional[zio.aws.textract.model.ExpenseDetection] =
      Optional.Absent,
    valueDetection: Optional[zio.aws.textract.model.ExpenseDetection] =
      Optional.Absent,
    pageNumber: Optional[UInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseField = {
    import ExpenseField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseField
      .builder()
      .optionallyWith(`type`.map(value => value.buildAwsValue()))(_.`type`)
      .optionallyWith(labelDetection.map(value => value.buildAwsValue()))(
        _.labelDetection
      )
      .optionallyWith(valueDetection.map(value => value.buildAwsValue()))(
        _.valueDetection
      )
      .optionallyWith(pageNumber.map(value => UInteger.unwrap(value): Integer))(
        _.pageNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseField.ReadOnly =
    zio.aws.textract.model.ExpenseField.wrap(buildAwsValue())
}
object ExpenseField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseField =
      zio.aws.textract.model.ExpenseField(
        `type`.map(value => value.asEditable),
        labelDetection.map(value => value.asEditable),
        valueDetection.map(value => value.asEditable),
        pageNumber.map(value => value)
      )
    def `type`: Optional[zio.aws.textract.model.ExpenseType.ReadOnly]
    def labelDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly]
    def valueDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly]
    def pageNumber: Optional[UInteger]
    def getType
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseType.ReadOnly] =
      AwsError.unwrapOptionField("type", `type`)
    def getLabelDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      AwsError.unwrapOptionField("labelDetection", labelDetection)
    def getValueDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      AwsError.unwrapOptionField("valueDetection", valueDetection)
    def getPageNumber: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseField
  ) extends zio.aws.textract.model.ExpenseField.ReadOnly {
    override val `type`: Optional[zio.aws.textract.model.ExpenseType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.textract.model.ExpenseType.wrap(value))
    override val labelDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDetection())
        .map(value => zio.aws.textract.model.ExpenseDetection.wrap(value))
    override val valueDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueDetection())
        .map(value => zio.aws.textract.model.ExpenseDetection.wrap(value))
    override val pageNumber: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.pageNumber())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseField
  ): zio.aws.textract.model.ExpenseField.ReadOnly = new Wrapper(impl)
}
