package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{FlowDefinitionArn, HumanLoopName}
import scala.jdk.CollectionConverters._
final case class HumanLoopConfig(
    humanLoopName: HumanLoopName,
    flowDefinitionArn: FlowDefinitionArn,
    dataAttributes: Option[zio.aws.textract.model.HumanLoopDataAttributes] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.HumanLoopConfig = {
    import HumanLoopConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.HumanLoopConfig
      .builder()
      .humanLoopName(HumanLoopName.unwrap(humanLoopName): java.lang.String)
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .optionallyWith(dataAttributes.map(value => value.buildAwsValue()))(
        _.dataAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.HumanLoopConfig.ReadOnly =
    zio.aws.textract.model.HumanLoopConfig.wrap(buildAwsValue())
}
object HumanLoopConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.HumanLoopConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.HumanLoopConfig =
      zio.aws.textract.model.HumanLoopConfig(
        humanLoopName,
        flowDefinitionArn,
        dataAttributes.map(value => value.asEditable)
      )
    def humanLoopName: HumanLoopName
    def flowDefinitionArn: FlowDefinitionArn
    def dataAttributes
        : Option[zio.aws.textract.model.HumanLoopDataAttributes.ReadOnly]
    def getHumanLoopName: ZIO[Any, Nothing, HumanLoopName] =
      ZIO.succeed(humanLoopName)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getDataAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.HumanLoopDataAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dataAttributes", dataAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.HumanLoopConfig
  ) extends zio.aws.textract.model.HumanLoopConfig.ReadOnly {
    override val humanLoopName: HumanLoopName =
      zio.aws.textract.model.primitives.HumanLoopName(impl.humanLoopName())
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.textract.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val dataAttributes
        : Option[zio.aws.textract.model.HumanLoopDataAttributes.ReadOnly] =
      scala
        .Option(impl.dataAttributes())
        .map(value =>
          zio.aws.textract.model.HumanLoopDataAttributes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.HumanLoopConfig
  ): zio.aws.textract.model.HumanLoopConfig.ReadOnly = new Wrapper(impl)
}
