package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HumanLoopDataAttributes(
    contentClassifiers: Option[
      Iterable[zio.aws.textract.model.ContentClassifier]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.HumanLoopDataAttributes = {
    import HumanLoopDataAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.HumanLoopDataAttributes
      .builder()
      .optionallyWith(
        contentClassifiers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contentClassifiersWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.HumanLoopDataAttributes.ReadOnly =
    zio.aws.textract.model.HumanLoopDataAttributes.wrap(buildAwsValue())
}
object HumanLoopDataAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.HumanLoopDataAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.HumanLoopDataAttributes =
      zio.aws.textract.model
        .HumanLoopDataAttributes(contentClassifiers.map(value => value))
    def contentClassifiers
        : Option[List[zio.aws.textract.model.ContentClassifier]]
    def getContentClassifiers
        : ZIO[Any, AwsError, List[zio.aws.textract.model.ContentClassifier]] =
      AwsError.unwrapOptionField("contentClassifiers", contentClassifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.HumanLoopDataAttributes
  ) extends zio.aws.textract.model.HumanLoopDataAttributes.ReadOnly {
    override val contentClassifiers
        : Option[List[zio.aws.textract.model.ContentClassifier]] = scala
      .Option(impl.contentClassifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.ContentClassifier.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.HumanLoopDataAttributes
  ): zio.aws.textract.model.HumanLoopDataAttributes.ReadOnly = new Wrapper(impl)
}
