package zio.aws.textract.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.UInteger
import scala.jdk.CollectionConverters._
final case class DocumentMetadata(pages: Option[UInteger] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DocumentMetadata = {
    import DocumentMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DocumentMetadata
      .builder()
      .optionallyWith(pages.map(value => UInteger.unwrap(value): Integer))(
        _.pages
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DocumentMetadata.ReadOnly =
    zio.aws.textract.model.DocumentMetadata.wrap(buildAwsValue())
}
object DocumentMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DocumentMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DocumentMetadata =
      zio.aws.textract.model.DocumentMetadata(pages.map(value => value))
    def pages: Option[UInteger]
    def getPages: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("pages", pages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DocumentMetadata
  ) extends zio.aws.textract.model.DocumentMetadata.ReadOnly {
    override val pages: Option[UInteger] = scala
      .Option(impl.pages())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DocumentMetadata
  ): zio.aws.textract.model.DocumentMetadata.ReadOnly = new Wrapper(impl)
}
