package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Data, MarkerName}
import scala.jdk.CollectionConverters.*
final case class MarkerRecordedEventAttributes(
    markerName: MarkerName,
    details: Optional[Data] = Optional.Absent,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.MarkerRecordedEventAttributes = {
    import MarkerRecordedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.MarkerRecordedEventAttributes
      .builder()
      .markerName(MarkerName.unwrap(markerName): java.lang.String)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly =
    zio.aws.swf.model.MarkerRecordedEventAttributes.wrap(buildAwsValue())
}
object MarkerRecordedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.MarkerRecordedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.MarkerRecordedEventAttributes =
      zio.aws.swf.model.MarkerRecordedEventAttributes(
        markerName,
        details.map(value => value),
        decisionTaskCompletedEventId
      )
    def markerName: MarkerName
    def details: Optional[Data]
    def decisionTaskCompletedEventId: EventId
    def getMarkerName: ZIO[Any, Nothing, MarkerName] = ZIO.succeed(markerName)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.MarkerRecordedEventAttributes
  ) extends zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly {
    override val markerName: MarkerName =
      zio.aws.swf.model.primitives.MarkerName(impl.markerName())
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.MarkerRecordedEventAttributes
  ): zio.aws.swf.model.MarkerRecordedEventAttributes.ReadOnly = new Wrapper(
    impl
  )
}
