package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{DurationInSecondsOptional, EventId, Data}
import scala.jdk.CollectionConverters.*
final case class DecisionTaskCompletedEventAttributes(
    executionContext: Optional[Data] = Optional.Absent,
    scheduledEventId: EventId,
    startedEventId: EventId,
    taskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    taskListScheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes = {
    import DecisionTaskCompletedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
      .builder()
      .optionallyWith(
        executionContext.map(value => Data.unwrap(value): java.lang.String)
      )(_.executionContext)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskListScheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskListScheduleToStartTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly =
    zio.aws.swf.model.DecisionTaskCompletedEventAttributes.wrap(buildAwsValue())
}
object DecisionTaskCompletedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DecisionTaskCompletedEventAttributes =
      zio.aws.swf.model.DecisionTaskCompletedEventAttributes(
        executionContext.map(value => value),
        scheduledEventId,
        startedEventId,
        taskList.map(value => value.asEditable),
        taskListScheduleToStartTimeout.map(value => value)
      )
    def executionContext: Optional[Data]
    def scheduledEventId: EventId
    def startedEventId: EventId
    def taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def taskListScheduleToStartTimeout: Optional[DurationInSecondsOptional]
    def getExecutionContext: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("executionContext", executionContext)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskListScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "taskListScheduleToStartTimeout",
        taskListScheduleToStartTimeout
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
  ) extends zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly {
    override val executionContext: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.executionContext())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskList())
        .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskListScheduleToStartTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.taskListScheduleToStartTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes
  ): zio.aws.swf.model.DecisionTaskCompletedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
