package zio.aws.swf.model
import zio.aws.swf.model.primitives.{ReverseOrder, PageSize, PageToken}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDomainsRequest(
    nextPageToken: Optional[PageToken] = Optional.Absent,
    registrationStatus: zio.aws.swf.model.RegistrationStatus,
    maximumPageSize: Optional[PageSize] = Optional.Absent,
    reverseOrder: Optional[ReverseOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListDomainsRequest = {
    import ListDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListDomainsRequest
      .builder()
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .registrationStatus(registrationStatus.unwrap)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListDomainsRequest.ReadOnly =
    zio.aws.swf.model.ListDomainsRequest.wrap(buildAwsValue())
}
object ListDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListDomainsRequest =
      zio.aws.swf.model.ListDomainsRequest(
        nextPageToken.map(value => value),
        registrationStatus,
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def nextPageToken: Optional[PageToken]
    def registrationStatus: zio.aws.swf.model.RegistrationStatus
    def maximumPageSize: Optional[PageSize]
    def reverseOrder: Optional[ReverseOrder]
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getRegistrationStatus
        : ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(registrationStatus)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListDomainsRequest
  ) extends zio.aws.swf.model.ListDomainsRequest.ReadOnly {
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val registrationStatus: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.registrationStatus())
    override val maximumPageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Optional[ReverseOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListDomainsRequest
  ): zio.aws.swf.model.ListDomainsRequest.ReadOnly = new Wrapper(impl)
}
