package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  Data,
  EventId,
  WorkflowRunIdOptional,
  WorkflowId
}
import scala.jdk.CollectionConverters.*
final case class RequestCancelExternalWorkflowExecutionInitiatedEventAttributes(
    workflowId: WorkflowId,
    runId: Optional[WorkflowRunIdOptional] = Optional.Absent,
    decisionTaskCompletedEventId: EventId,
    control: Optional[Data] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes = {
    import RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        runId.map(value =>
          WorkflowRunIdOptional.unwrap(value): java.lang.String
        )
      )(_.runId)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
      .wrap(buildAwsValue())
}
object RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes =
      zio.aws.swf.model
        .RequestCancelExternalWorkflowExecutionInitiatedEventAttributes(
          workflowId,
          runId.map(value => value),
          decisionTaskCompletedEventId,
          control.map(value => value)
        )
    def workflowId: WorkflowId
    def runId: Optional[WorkflowRunIdOptional]
    def decisionTaskCompletedEventId: EventId
    def control: Optional[Data]
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, AwsError, WorkflowRunIdOptional] =
      AwsError.unwrapOptionField("runId", runId)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
  ) extends zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: Optional[WorkflowRunIdOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.swf.model.primitives.WorkflowRunIdOptional(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
    override val control: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
  ): zio.aws.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
