package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Identity}
import scala.jdk.CollectionConverters.*
final case class DecisionTaskStartedEventAttributes(
    identity: Optional[Identity] = Optional.Absent,
    scheduledEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DecisionTaskStartedEventAttributes = {
    import DecisionTaskStartedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DecisionTaskStartedEventAttributes
      .builder()
      .optionallyWith(
        identity.map(value => Identity.unwrap(value): java.lang.String)
      )(_.identity)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly =
    zio.aws.swf.model.DecisionTaskStartedEventAttributes.wrap(buildAwsValue())
}
object DecisionTaskStartedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DecisionTaskStartedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DecisionTaskStartedEventAttributes =
      zio.aws.swf.model.DecisionTaskStartedEventAttributes(
        identity.map(value => value),
        scheduledEventId
      )
    def identity: Optional[Identity]
    def scheduledEventId: EventId
    def getIdentity: ZIO[Any, AwsError, Identity] =
      AwsError.unwrapOptionField("identity", identity)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskStartedEventAttributes
  ) extends zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly {
    override val identity: Optional[Identity] = zio.aws.core.internal
      .optionalFromNullable(impl.identity())
      .map(value => zio.aws.swf.model.primitives.Identity(value))
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskStartedEventAttributes
  ): zio.aws.swf.model.DecisionTaskStartedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
