package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{DurationInSecondsOptional, Data, TaskToken}
import scala.jdk.CollectionConverters.*
final case class RespondDecisionTaskCompletedRequest(
    taskToken: TaskToken,
    decisions: Optional[Iterable[zio.aws.swf.model.Decision]] = Optional.Absent,
    executionContext: Optional[Data] = Optional.Absent,
    taskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    taskListScheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest = {
    import RespondDecisionTaskCompletedRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .optionallyWith(
        decisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.decisions)
      .optionallyWith(
        executionContext.map(value => Data.unwrap(value): java.lang.String)
      )(_.executionContext)
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskListScheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskListScheduleToStartTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.RespondDecisionTaskCompletedRequest.ReadOnly =
    zio.aws.swf.model.RespondDecisionTaskCompletedRequest.wrap(buildAwsValue())
}
object RespondDecisionTaskCompletedRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RespondDecisionTaskCompletedRequest =
      zio.aws.swf.model.RespondDecisionTaskCompletedRequest(
        taskToken,
        decisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionContext.map(value => value),
        taskList.map(value => value.asEditable),
        taskListScheduleToStartTimeout.map(value => value)
      )
    def taskToken: TaskToken
    def decisions: Optional[List[zio.aws.swf.model.Decision.ReadOnly]]
    def executionContext: Optional[Data]
    def taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def taskListScheduleToStartTimeout: Optional[DurationInSecondsOptional]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getDecisions
        : ZIO[Any, AwsError, List[zio.aws.swf.model.Decision.ReadOnly]] =
      AwsError.unwrapOptionField("decisions", decisions)
    def getExecutionContext: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("executionContext", executionContext)
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskListScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "taskListScheduleToStartTimeout",
        taskListScheduleToStartTimeout
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
  ) extends zio.aws.swf.model.RespondDecisionTaskCompletedRequest.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val decisions
        : Optional[List[zio.aws.swf.model.Decision.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.swf.model.Decision.wrap(item)
          }.toList
        )
    override val executionContext: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.executionContext())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskList())
        .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskListScheduleToStartTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.taskListScheduleToStartTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest
  ): zio.aws.swf.model.RespondDecisionTaskCompletedRequest.ReadOnly =
    new Wrapper(impl)
}
