package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, TimerId}
import scala.jdk.CollectionConverters.*
final case class TimerCanceledEventAttributes(
    timerId: TimerId,
    startedEventId: EventId,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes = {
    import TimerCanceledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly =
    zio.aws.swf.model.TimerCanceledEventAttributes.wrap(buildAwsValue())
}
object TimerCanceledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TimerCanceledEventAttributes =
      zio.aws.swf.model.TimerCanceledEventAttributes(
        timerId,
        startedEventId,
        decisionTaskCompletedEventId
      )
    def timerId: TimerId
    def startedEventId: EventId
    def decisionTaskCompletedEventId: EventId
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes
  ) extends zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes
  ): zio.aws.swf.model.TimerCanceledEventAttributes.ReadOnly = new Wrapper(impl)
}
