package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkflowTypeResponse(
    typeInfo: zio.aws.swf.model.WorkflowTypeInfo,
    configuration: zio.aws.swf.model.WorkflowTypeConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse = {
    import DescribeWorkflowTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse
      .builder()
      .typeInfo(typeInfo.buildAwsValue())
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly =
    zio.aws.swf.model.DescribeWorkflowTypeResponse.wrap(buildAwsValue())
}
object DescribeWorkflowTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeWorkflowTypeResponse =
      zio.aws.swf.model.DescribeWorkflowTypeResponse(
        typeInfo.asEditable,
        configuration.asEditable
      )
    def typeInfo: zio.aws.swf.model.WorkflowTypeInfo.ReadOnly
    def configuration: zio.aws.swf.model.WorkflowTypeConfiguration.ReadOnly
    def getTypeInfo
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowTypeInfo.ReadOnly] =
      ZIO.succeed(typeInfo)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.swf.model.WorkflowTypeConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse
  ) extends zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly {
    override val typeInfo: zio.aws.swf.model.WorkflowTypeInfo.ReadOnly =
      zio.aws.swf.model.WorkflowTypeInfo.wrap(impl.typeInfo())
    override val configuration
        : zio.aws.swf.model.WorkflowTypeConfiguration.ReadOnly =
      zio.aws.swf.model.WorkflowTypeConfiguration.wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeWorkflowTypeResponse
  ): zio.aws.swf.model.DescribeWorkflowTypeResponse.ReadOnly = new Wrapper(impl)
}
