package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.swf.model.ResourceTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.TagResourceRequest.ReadOnly =
    zio.aws.swf.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.TagResourceRequest =
      zio.aws.swf.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.swf.model.ResourceTag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.swf.model.ResourceTag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.TagResourceRequest
  ) extends zio.aws.swf.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.swf.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.swf.model.ResourceTag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.swf.model.ResourceTag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.TagResourceRequest
  ): zio.aws.swf.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
