package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Data, FailureReason}
import scala.jdk.CollectionConverters.*
final case class ChildWorkflowExecutionFailedEventAttributes(
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    workflowType: zio.aws.swf.model.WorkflowType,
    reason: Optional[FailureReason] = Optional.Absent,
    details: Optional[Data] = Optional.Absent,
    initiatedEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionFailedEventAttributes = {
    import ChildWorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionFailedEventAttributes
      .builder()
      .workflowExecution(workflowExecution.buildAwsValue())
      .workflowType(workflowType.buildAwsValue())
      .optionallyWith(
        reason.map(value => FailureReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object ChildWorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes(
        workflowExecution.asEditable,
        workflowType.asEditable,
        reason.map(value => value),
        details.map(value => value),
        initiatedEventId,
        startedEventId
      )
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def reason: Optional[FailureReason]
    def details: Optional[Data]
    def initiatedEventId: EventId
    def startedEventId: EventId
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly {
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val reason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.swf.model.primitives.FailureReason(value))
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.ChildWorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
