package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.EventId
import scala.jdk.CollectionConverters.*
final case class ChildWorkflowExecutionTerminatedEventAttributes(
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    workflowType: zio.aws.swf.model.WorkflowType,
    initiatedEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes = {
    import ChildWorkflowExecutionTerminatedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
      .builder()
      .workflowExecution(workflowExecution.buildAwsValue())
      .workflowType(workflowType.buildAwsValue())
      .initiatedEventId(EventId.unwrap(initiatedEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly =
    zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
      .wrap(buildAwsValue())
}
object ChildWorkflowExecutionTerminatedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes =
      zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes(
        workflowExecution.asEditable,
        workflowType.asEditable,
        initiatedEventId,
        startedEventId
      )
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def initiatedEventId: EventId
    def startedEventId: EventId
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getInitiatedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(initiatedEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
  ) extends zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly {
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val initiatedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.initiatedEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes
  ): zio.aws.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
