package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDomainResponse(
    domainInfo: zio.aws.swf.model.DomainInfo,
    configuration: zio.aws.swf.model.DomainConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DescribeDomainResponse = {
    import DescribeDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DescribeDomainResponse
      .builder()
      .domainInfo(domainInfo.buildAwsValue())
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DescribeDomainResponse.ReadOnly =
    zio.aws.swf.model.DescribeDomainResponse.wrap(buildAwsValue())
}
object DescribeDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DescribeDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DescribeDomainResponse = zio.aws.swf.model
      .DescribeDomainResponse(domainInfo.asEditable, configuration.asEditable)
    def domainInfo: zio.aws.swf.model.DomainInfo.ReadOnly
    def configuration: zio.aws.swf.model.DomainConfiguration.ReadOnly
    def getDomainInfo
        : ZIO[Any, Nothing, zio.aws.swf.model.DomainInfo.ReadOnly] =
      ZIO.succeed(domainInfo)
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.swf.model.DomainConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DescribeDomainResponse
  ) extends zio.aws.swf.model.DescribeDomainResponse.ReadOnly {
    override val domainInfo: zio.aws.swf.model.DomainInfo.ReadOnly =
      zio.aws.swf.model.DomainInfo.wrap(impl.domainInfo())
    override val configuration: zio.aws.swf.model.DomainConfiguration.ReadOnly =
      zio.aws.swf.model.DomainConfiguration.wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DescribeDomainResponse
  ): zio.aws.swf.model.DescribeDomainResponse.ReadOnly = new Wrapper(impl)
}
