package zio.aws.swf.model
import scala.jdk.CollectionConverters.*
sealed trait ChildPolicy {
  def unwrap: software.amazon.awssdk.services.swf.model.ChildPolicy
}
object ChildPolicy {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.ChildPolicy
  ): zio.aws.swf.model.ChildPolicy = value match {
    case software.amazon.awssdk.services.swf.model.ChildPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.ChildPolicy.TERMINATE =>
      val r = TERMINATE
      r
    case software.amazon.awssdk.services.swf.model.ChildPolicy.REQUEST_CANCEL =>
      val r = REQUEST_CANCEL
      r
    case software.amazon.awssdk.services.swf.model.ChildPolicy.ABANDON =>
      val r = ABANDON
      r
  }
  case object unknownToSdkVersion extends zio.aws.swf.model.ChildPolicy {
    override def unwrap: software.amazon.awssdk.services.swf.model.ChildPolicy =
      software.amazon.awssdk.services.swf.model.ChildPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object TERMINATE extends zio.aws.swf.model.ChildPolicy {
    override def unwrap: software.amazon.awssdk.services.swf.model.ChildPolicy =
      software.amazon.awssdk.services.swf.model.ChildPolicy.TERMINATE
  }
  case object REQUEST_CANCEL extends zio.aws.swf.model.ChildPolicy {
    override def unwrap: software.amazon.awssdk.services.swf.model.ChildPolicy =
      software.amazon.awssdk.services.swf.model.ChildPolicy.REQUEST_CANCEL
  }
  case object ABANDON extends zio.aws.swf.model.ChildPolicy {
    override def unwrap: software.amazon.awssdk.services.swf.model.ChildPolicy =
      software.amazon.awssdk.services.swf.model.ChildPolicy.ABANDON
  }
}
