package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{PageToken, EventId, TaskToken}
import scala.jdk.CollectionConverters.*
final case class PollForDecisionTaskResponse(
    taskToken: TaskToken,
    startedEventId: EventId,
    workflowExecution: zio.aws.swf.model.WorkflowExecution,
    workflowType: zio.aws.swf.model.WorkflowType,
    events: Iterable[zio.aws.swf.model.HistoryEvent],
    nextPageToken: Optional[PageToken] = Optional.Absent,
    previousStartedEventId: Optional[EventId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse = {
    import PollForDecisionTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse
      .builder()
      .taskToken(TaskToken.unwrap(taskToken): java.lang.String)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .workflowExecution(workflowExecution.buildAwsValue())
      .workflowType(workflowType.buildAwsValue())
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        previousStartedEventId.map(value =>
          EventId.unwrap(value): java.lang.Long
        )
      )(_.previousStartedEventId)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly =
    zio.aws.swf.model.PollForDecisionTaskResponse.wrap(buildAwsValue())
}
object PollForDecisionTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.PollForDecisionTaskResponse =
      zio.aws.swf.model.PollForDecisionTaskResponse(
        taskToken,
        startedEventId,
        workflowExecution.asEditable,
        workflowType.asEditable,
        events.map { item =>
          item.asEditable
        },
        nextPageToken.map(value => value),
        previousStartedEventId.map(value => value)
      )
    def taskToken: TaskToken
    def startedEventId: EventId
    def workflowExecution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def workflowType: zio.aws.swf.model.WorkflowType.ReadOnly
    def events: List[zio.aws.swf.model.HistoryEvent.ReadOnly]
    def nextPageToken: Optional[PageToken]
    def previousStartedEventId: Optional[EventId]
    def getTaskToken: ZIO[Any, Nothing, TaskToken] = ZIO.succeed(taskToken)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getWorkflowExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(workflowExecution)
    def getWorkflowType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowType.ReadOnly] =
      ZIO.succeed(workflowType)
    def getEvents
        : ZIO[Any, Nothing, List[zio.aws.swf.model.HistoryEvent.ReadOnly]] =
      ZIO.succeed(events)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getPreviousStartedEventId: ZIO[Any, AwsError, EventId] = AwsError
      .unwrapOptionField("previousStartedEventId", previousStartedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse
  ) extends zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly {
    override val taskToken: TaskToken =
      zio.aws.swf.model.primitives.TaskToken(impl.taskToken())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val workflowExecution
        : zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.workflowExecution())
    override val workflowType: zio.aws.swf.model.WorkflowType.ReadOnly =
      zio.aws.swf.model.WorkflowType.wrap(impl.workflowType())
    override val events: List[zio.aws.swf.model.HistoryEvent.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.swf.model.HistoryEvent.wrap(item)
      }
      .toList
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val previousStartedEventId: Optional[EventId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousStartedEventId())
        .map(value => zio.aws.swf.model.primitives.EventId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse
  ): zio.aws.swf.model.PollForDecisionTaskResponse.ReadOnly = new Wrapper(impl)
}
