package zio.aws.swf.model
import scala.jdk.CollectionConverters.*
sealed trait WorkflowExecutionTerminatedCause {
  def unwrap: software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause
}
object WorkflowExecutionTerminatedCause {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause
  ): zio.aws.swf.model.WorkflowExecutionTerminatedCause = value match {
    case software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.CHILD_POLICY_APPLIED =>
      val r = CHILD_POLICY_APPLIED
      r
    case software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.EVENT_LIMIT_EXCEEDED =>
      val r = EVENT_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.OPERATOR_INITIATED =>
      val r = OPERATOR_INITIATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.WorkflowExecutionTerminatedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause =
      software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.UNKNOWN_TO_SDK_VERSION
  }
  case object CHILD_POLICY_APPLIED
      extends zio.aws.swf.model.WorkflowExecutionTerminatedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause =
      software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.CHILD_POLICY_APPLIED
  }
  case object EVENT_LIMIT_EXCEEDED
      extends zio.aws.swf.model.WorkflowExecutionTerminatedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause =
      software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.EVENT_LIMIT_EXCEEDED
  }
  case object OPERATOR_INITIATED
      extends zio.aws.swf.model.WorkflowExecutionTerminatedCause {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause =
      software.amazon.awssdk.services.swf.model.WorkflowExecutionTerminatedCause.OPERATOR_INITIATED
  }
}
