package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{WorkflowRunId, WorkflowId}
import scala.jdk.CollectionConverters.*
final case class WorkflowExecution(
    workflowId: WorkflowId,
    runId: WorkflowRunId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecution = {
    import WorkflowExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecution
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .runId(WorkflowRunId.unwrap(runId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.WorkflowExecution.ReadOnly =
    zio.aws.swf.model.WorkflowExecution.wrap(buildAwsValue())
}
object WorkflowExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecution =
      zio.aws.swf.model.WorkflowExecution(workflowId, runId)
    def workflowId: WorkflowId
    def runId: WorkflowRunId
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getRunId: ZIO[Any, Nothing, WorkflowRunId] = ZIO.succeed(runId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecution
  ) extends zio.aws.swf.model.WorkflowExecution.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.swf.model.primitives.WorkflowId(impl.workflowId())
    override val runId: WorkflowRunId =
      zio.aws.swf.model.primitives.WorkflowRunId(impl.runId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecution
  ): zio.aws.swf.model.WorkflowExecution.ReadOnly = new Wrapper(impl)
}
