package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class DeprecateDomainRequest(name: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DeprecateDomainRequest = {
    import DeprecateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DeprecateDomainRequest
      .builder()
      .name(DomainName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.DeprecateDomainRequest.ReadOnly =
    zio.aws.swf.model.DeprecateDomainRequest.wrap(buildAwsValue())
}
object DeprecateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DeprecateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DeprecateDomainRequest =
      zio.aws.swf.model.DeprecateDomainRequest(name)
    def name: DomainName
    def getName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DeprecateDomainRequest
  ) extends zio.aws.swf.model.DeprecateDomainRequest.ReadOnly {
    override val name: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DeprecateDomainRequest
  ): zio.aws.swf.model.DeprecateDomainRequest.ReadOnly = new Wrapper(impl)
}
