package zio.aws.swf.model
import zio.aws.swf.model.primitives.{Truncated, Count}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CountPendingActivityTasksResponse(
    count: Count,
    truncated: Optional[Truncated] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse = {
    import CountPendingActivityTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse
      .builder()
      .count(Count.unwrap(count): Integer)
      .optionallyWith(
        truncated.map(value => Truncated.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly =
    zio.aws.swf.model.CountPendingActivityTasksResponse.wrap(buildAwsValue())
}
object CountPendingActivityTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CountPendingActivityTasksResponse =
      zio.aws.swf.model
        .CountPendingActivityTasksResponse(count, truncated.map(value => value))
    def count: Count
    def truncated: Optional[Truncated]
    def getCount: ZIO[Any, Nothing, Count] = ZIO.succeed(count)
    def getTruncated: ZIO[Any, AwsError, Truncated] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse
  ) extends zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly {
    override val count: Count = zio.aws.swf.model.primitives.Count(impl.count())
    override val truncated: Optional[Truncated] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.swf.model.primitives.Truncated(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CountPendingActivityTasksResponse
  ): zio.aws.swf.model.CountPendingActivityTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
