package zio.aws.swf.model
import scala.jdk.CollectionConverters.*
sealed trait CloseStatus {
  def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus
}
object CloseStatus {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.CloseStatus
  ): zio.aws.swf.model.CloseStatus = value match {
    case software.amazon.awssdk.services.swf.model.CloseStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.CloseStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.swf.model.CloseStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.swf.model.CloseStatus.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.swf.model.CloseStatus.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.swf.model.CloseStatus.CONTINUED_AS_NEW =>
      val r = CONTINUED_AS_NEW
      r
    case software.amazon.awssdk.services.swf.model.CloseStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
  }
  case object unknownToSdkVersion extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.COMPLETED
  }
  case object FAILED extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.FAILED
  }
  case object CANCELED extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.CANCELED
  }
  case object TERMINATED extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.TERMINATED
  }
  case object CONTINUED_AS_NEW extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.CONTINUED_AS_NEW
  }
  case object TIMED_OUT extends zio.aws.swf.model.CloseStatus {
    override def unwrap: software.amazon.awssdk.services.swf.model.CloseStatus =
      software.amazon.awssdk.services.swf.model.CloseStatus.TIMED_OUT
  }
}
