package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, MarkerName}
import scala.jdk.CollectionConverters.*
final case class RecordMarkerFailedEventAttributes(
    markerName: MarkerName,
    cause: zio.aws.swf.model.RecordMarkerFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.RecordMarkerFailedEventAttributes = {
    import RecordMarkerFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.RecordMarkerFailedEventAttributes
      .builder()
      .markerName(MarkerName.unwrap(markerName): java.lang.String)
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.RecordMarkerFailedEventAttributes.wrap(buildAwsValue())
}
object RecordMarkerFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.RecordMarkerFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.RecordMarkerFailedEventAttributes =
      zio.aws.swf.model.RecordMarkerFailedEventAttributes(
        markerName,
        cause,
        decisionTaskCompletedEventId
      )
    def markerName: MarkerName
    def cause: zio.aws.swf.model.RecordMarkerFailedCause
    def decisionTaskCompletedEventId: EventId
    def getMarkerName: ZIO[Any, Nothing, MarkerName] = ZIO.succeed(markerName)
    def getCause: ZIO[Any, Nothing, zio.aws.swf.model.RecordMarkerFailedCause] =
      ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.RecordMarkerFailedEventAttributes
  ) extends zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly {
    override val markerName: MarkerName =
      zio.aws.swf.model.primitives.MarkerName(impl.markerName())
    override val cause: zio.aws.swf.model.RecordMarkerFailedCause =
      zio.aws.swf.model.RecordMarkerFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.RecordMarkerFailedEventAttributes
  ): zio.aws.swf.model.RecordMarkerFailedEventAttributes.ReadOnly = new Wrapper(
    impl
  )
}
