package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{DurationInSecondsOptional, TaskPriority}
import scala.jdk.CollectionConverters.*
final case class DecisionTaskScheduledEventAttributes(
    taskList: zio.aws.swf.model.TaskList,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    startToCloseTimeout: Optional[DurationInSecondsOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.DecisionTaskScheduledEventAttributes = {
    import DecisionTaskScheduledEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.DecisionTaskScheduledEventAttributes
      .builder()
      .taskList(taskList.buildAwsValue())
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly =
    zio.aws.swf.model.DecisionTaskScheduledEventAttributes.wrap(buildAwsValue())
}
object DecisionTaskScheduledEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.DecisionTaskScheduledEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.DecisionTaskScheduledEventAttributes =
      zio.aws.swf.model.DecisionTaskScheduledEventAttributes(
        taskList.asEditable,
        taskPriority.map(value => value),
        startToCloseTimeout.map(value => value)
      )
    def taskList: zio.aws.swf.model.TaskList.ReadOnly
    def taskPriority: Optional[TaskPriority]
    def startToCloseTimeout: Optional[DurationInSecondsOptional]
    def getTaskList: ZIO[Any, Nothing, zio.aws.swf.model.TaskList.ReadOnly] =
      ZIO.succeed(taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskScheduledEventAttributes
  ) extends zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly {
    override val taskList: zio.aws.swf.model.TaskList.ReadOnly =
      zio.aws.swf.model.TaskList.wrap(impl.taskList())
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val startToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.DecisionTaskScheduledEventAttributes
  ): zio.aws.swf.model.DecisionTaskScheduledEventAttributes.ReadOnly =
    new Wrapper(impl)
}
