package zio.aws.swf.model
import zio.aws.swf.model.primitives.{
  ReverseOrder,
  DomainName,
  PageToken,
  PageSize,
  Name
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkflowTypesRequest(
    domain: DomainName,
    name: Optional[Name] = Optional.Absent,
    registrationStatus: zio.aws.swf.model.RegistrationStatus,
    nextPageToken: Optional[PageToken] = Optional.Absent,
    maximumPageSize: Optional[PageSize] = Optional.Absent,
    reverseOrder: Optional[ReverseOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest = {
    import ListWorkflowTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .registrationStatus(registrationStatus.unwrap)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.ListWorkflowTypesRequest.ReadOnly =
    zio.aws.swf.model.ListWorkflowTypesRequest.wrap(buildAwsValue())
}
object ListWorkflowTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ListWorkflowTypesRequest =
      zio.aws.swf.model.ListWorkflowTypesRequest(
        domain,
        name.map(value => value),
        registrationStatus,
        nextPageToken.map(value => value),
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def domain: DomainName
    def name: Optional[Name]
    def registrationStatus: zio.aws.swf.model.RegistrationStatus
    def nextPageToken: Optional[PageToken]
    def maximumPageSize: Optional[PageSize]
    def reverseOrder: Optional[ReverseOrder]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRegistrationStatus
        : ZIO[Any, Nothing, zio.aws.swf.model.RegistrationStatus] =
      ZIO.succeed(registrationStatus)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest
  ) extends zio.aws.swf.model.ListWorkflowTypesRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.swf.model.primitives.Name(value))
    override val registrationStatus: zio.aws.swf.model.RegistrationStatus =
      zio.aws.swf.model.RegistrationStatus.wrap(impl.registrationStatus())
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val maximumPageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Optional[ReverseOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ListWorkflowTypesRequest
  ): zio.aws.swf.model.ListWorkflowTypesRequest.ReadOnly = new Wrapper(impl)
}
