package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.TimerId
import scala.jdk.CollectionConverters.*
final case class CancelTimerDecisionAttributes(timerId: TimerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CancelTimerDecisionAttributes = {
    import CancelTimerDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CancelTimerDecisionAttributes
      .builder()
      .timerId(TimerId.unwrap(timerId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly =
    zio.aws.swf.model.CancelTimerDecisionAttributes.wrap(buildAwsValue())
}
object CancelTimerDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CancelTimerDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CancelTimerDecisionAttributes =
      zio.aws.swf.model.CancelTimerDecisionAttributes(timerId)
    def timerId: TimerId
    def getTimerId: ZIO[Any, Nothing, TimerId] = ZIO.succeed(timerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CancelTimerDecisionAttributes
  ) extends zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly {
    override val timerId: TimerId =
      zio.aws.swf.model.primitives.TimerId(impl.timerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CancelTimerDecisionAttributes
  ): zio.aws.swf.model.CancelTimerDecisionAttributes.ReadOnly = new Wrapper(
    impl
  )
}
