package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class WorkflowExecutionTimedOutEventAttributes(
    timeoutType: zio.aws.swf.model.WorkflowExecutionTimeoutType,
    childPolicy: zio.aws.swf.model.ChildPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionTimedOutEventAttributes = {
    import WorkflowExecutionTimedOutEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionTimedOutEventAttributes
      .builder()
      .timeoutType(timeoutType.unwrap)
      .childPolicy(childPolicy.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionTimedOutEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionTimedOutEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes =
      zio.aws.swf.model
        .WorkflowExecutionTimedOutEventAttributes(timeoutType, childPolicy)
    def timeoutType: zio.aws.swf.model.WorkflowExecutionTimeoutType
    def childPolicy: zio.aws.swf.model.ChildPolicy
    def getTimeoutType
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecutionTimeoutType] =
      ZIO.succeed(timeoutType)
    def getChildPolicy: ZIO[Any, Nothing, zio.aws.swf.model.ChildPolicy] =
      ZIO.succeed(childPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionTimedOutEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly {
    override val timeoutType: zio.aws.swf.model.WorkflowExecutionTimeoutType =
      zio.aws.swf.model.WorkflowExecutionTimeoutType.wrap(impl.timeoutType())
    override val childPolicy: zio.aws.swf.model.ChildPolicy =
      zio.aws.swf.model.ChildPolicy.wrap(impl.childPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionTimedOutEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionTimedOutEventAttributes.ReadOnly =
    new Wrapper(impl)
}
