package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  DurationInSecondsOptional,
  Data,
  ActivityId
}
import scala.jdk.CollectionConverters.*
final case class ScheduleActivityTaskDecisionAttributes(
    activityType: zio.aws.swf.model.ActivityType,
    activityId: ActivityId,
    control: Optional[Data] = Optional.Absent,
    input: Optional[Data] = Optional.Absent,
    scheduleToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    taskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    scheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    startToCloseTimeout: Optional[DurationInSecondsOptional] = Optional.Absent,
    heartbeatTimeout: Optional[DurationInSecondsOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes = {
    import ScheduleActivityTaskDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
      .builder()
      .activityType(activityType.buildAwsValue())
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .optionallyWith(
        control.map(value => Data.unwrap(value): java.lang.String)
      )(_.control)
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        scheduleToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToCloseTimeout)
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(
        scheduleToStartTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.scheduleToStartTimeout)
      .optionallyWith(
        startToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.startToCloseTimeout)
      .optionallyWith(
        heartbeatTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.heartbeatTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly =
    zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes
      .wrap(buildAwsValue())
}
object ScheduleActivityTaskDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes =
      zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes(
        activityType.asEditable,
        activityId,
        control.map(value => value),
        input.map(value => value),
        scheduleToCloseTimeout.map(value => value),
        taskList.map(value => value.asEditable),
        taskPriority.map(value => value),
        scheduleToStartTimeout.map(value => value),
        startToCloseTimeout.map(value => value),
        heartbeatTimeout.map(value => value)
      )
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def activityId: ActivityId
    def control: Optional[Data]
    def input: Optional[Data]
    def scheduleToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def taskPriority: Optional[TaskPriority]
    def scheduleToStartTimeout: Optional[DurationInSecondsOptional]
    def startToCloseTimeout: Optional[DurationInSecondsOptional]
    def heartbeatTimeout: Optional[DurationInSecondsOptional]
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getControl: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("control", control)
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getScheduleToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToCloseTimeout", scheduleToCloseTimeout)
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getScheduleToStartTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("scheduleToStartTimeout", scheduleToStartTimeout)
    def getStartToCloseTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("startToCloseTimeout", startToCloseTimeout)
    def getHeartbeatTimeout: ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField("heartbeatTimeout", heartbeatTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
  ) extends zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly {
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val control: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.control())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduleToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskList())
        .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val scheduleToStartTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleToStartTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val startToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val heartbeatTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.heartbeatTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes
  ): zio.aws.swf.model.ScheduleActivityTaskDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
