package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{LimitedData, EventId}
import scala.jdk.CollectionConverters.*
final case class ActivityTaskTimedOutEventAttributes(
    timeoutType: zio.aws.swf.model.ActivityTaskTimeoutType,
    scheduledEventId: EventId,
    startedEventId: EventId,
    details: Optional[LimitedData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes = {
    import ActivityTaskTimedOutEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes
      .builder()
      .timeoutType(timeoutType.unwrap)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .optionallyWith(
        details.map(value => LimitedData.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.wrap(buildAwsValue())
}
object ActivityTaskTimedOutEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTaskTimedOutEventAttributes =
      zio.aws.swf.model.ActivityTaskTimedOutEventAttributes(
        timeoutType,
        scheduledEventId,
        startedEventId,
        details.map(value => value)
      )
    def timeoutType: zio.aws.swf.model.ActivityTaskTimeoutType
    def scheduledEventId: EventId
    def startedEventId: EventId
    def details: Optional[LimitedData]
    def getTimeoutType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityTaskTimeoutType] =
      ZIO.succeed(timeoutType)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
    def getDetails: ZIO[Any, AwsError, LimitedData] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly {
    override val timeoutType: zio.aws.swf.model.ActivityTaskTimeoutType =
      zio.aws.swf.model.ActivityTaskTimeoutType.wrap(impl.timeoutType())
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
    override val details: Optional[LimitedData] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.LimitedData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes
  ): zio.aws.swf.model.ActivityTaskTimedOutEventAttributes.ReadOnly =
    new Wrapper(impl)
}
