package zio.aws.swf.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionStatus {
  def unwrap: software.amazon.awssdk.services.swf.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.ExecutionStatus
  ): zio.aws.swf.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.swf.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.ExecutionStatus.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.swf.model.ExecutionStatus.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion extends zio.aws.swf.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ExecutionStatus =
      software.amazon.awssdk.services.swf.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.swf.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ExecutionStatus =
      software.amazon.awssdk.services.swf.model.ExecutionStatus.OPEN
  }
  case object CLOSED extends zio.aws.swf.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.ExecutionStatus =
      software.amazon.awssdk.services.swf.model.ExecutionStatus.CLOSED
  }
}
