package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class CountClosedWorkflowExecutionsRequest(
    domain: DomainName,
    startTimeFilter: Optional[zio.aws.swf.model.ExecutionTimeFilter] =
      Optional.Absent,
    closeTimeFilter: Optional[zio.aws.swf.model.ExecutionTimeFilter] =
      Optional.Absent,
    executionFilter: Optional[zio.aws.swf.model.WorkflowExecutionFilter] =
      Optional.Absent,
    typeFilter: Optional[zio.aws.swf.model.WorkflowTypeFilter] =
      Optional.Absent,
    tagFilter: Optional[zio.aws.swf.model.TagFilter] = Optional.Absent,
    closeStatusFilter: Optional[zio.aws.swf.model.CloseStatusFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest = {
    import CountClosedWorkflowExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(startTimeFilter.map(value => value.buildAwsValue()))(
        _.startTimeFilter
      )
      .optionallyWith(closeTimeFilter.map(value => value.buildAwsValue()))(
        _.closeTimeFilter
      )
      .optionallyWith(executionFilter.map(value => value.buildAwsValue()))(
        _.executionFilter
      )
      .optionallyWith(typeFilter.map(value => value.buildAwsValue()))(
        _.typeFilter
      )
      .optionallyWith(tagFilter.map(value => value.buildAwsValue()))(
        _.tagFilter
      )
      .optionallyWith(closeStatusFilter.map(value => value.buildAwsValue()))(
        _.closeStatusFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.CountClosedWorkflowExecutionsRequest.ReadOnly =
    zio.aws.swf.model.CountClosedWorkflowExecutionsRequest.wrap(buildAwsValue())
}
object CountClosedWorkflowExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.CountClosedWorkflowExecutionsRequest =
      zio.aws.swf.model.CountClosedWorkflowExecutionsRequest(
        domain,
        startTimeFilter.map(value => value.asEditable),
        closeTimeFilter.map(value => value.asEditable),
        executionFilter.map(value => value.asEditable),
        typeFilter.map(value => value.asEditable),
        tagFilter.map(value => value.asEditable),
        closeStatusFilter.map(value => value.asEditable)
      )
    def domain: DomainName
    def startTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly]
    def closeTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly]
    def executionFilter
        : Optional[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly]
    def typeFilter: Optional[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly]
    def tagFilter: Optional[zio.aws.swf.model.TagFilter.ReadOnly]
    def closeStatusFilter
        : Optional[zio.aws.swf.model.CloseStatusFilter.ReadOnly]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getStartTimeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      AwsError.unwrapOptionField("startTimeFilter", startTimeFilter)
    def getCloseTimeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      AwsError.unwrapOptionField("closeTimeFilter", closeTimeFilter)
    def getExecutionFilter: ZIO[
      Any,
      AwsError,
      zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("executionFilter", executionFilter)
    def getTypeFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      AwsError.unwrapOptionField("typeFilter", typeFilter)
    def getTagFilter: ZIO[Any, AwsError, zio.aws.swf.model.TagFilter.ReadOnly] =
      AwsError.unwrapOptionField("tagFilter", tagFilter)
    def getCloseStatusFilter
        : ZIO[Any, AwsError, zio.aws.swf.model.CloseStatusFilter.ReadOnly] =
      AwsError.unwrapOptionField("closeStatusFilter", closeStatusFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest
  ) extends zio.aws.swf.model.CountClosedWorkflowExecutionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val startTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeFilter())
        .map(value => zio.aws.swf.model.ExecutionTimeFilter.wrap(value))
    override val closeTimeFilter
        : Optional[zio.aws.swf.model.ExecutionTimeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.closeTimeFilter())
        .map(value => zio.aws.swf.model.ExecutionTimeFilter.wrap(value))
    override val executionFilter
        : Optional[zio.aws.swf.model.WorkflowExecutionFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionFilter())
        .map(value => zio.aws.swf.model.WorkflowExecutionFilter.wrap(value))
    override val typeFilter
        : Optional[zio.aws.swf.model.WorkflowTypeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeFilter())
        .map(value => zio.aws.swf.model.WorkflowTypeFilter.wrap(value))
    override val tagFilter: Optional[zio.aws.swf.model.TagFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilter())
        .map(value => zio.aws.swf.model.TagFilter.wrap(value))
    override val closeStatusFilter
        : Optional[zio.aws.swf.model.CloseStatusFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.closeStatusFilter())
        .map(value => zio.aws.swf.model.CloseStatusFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.CountClosedWorkflowExecutionsRequest
  ): zio.aws.swf.model.CountClosedWorkflowExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
