package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Data}
import scala.jdk.CollectionConverters.*
final case class ActivityTaskCompletedEventAttributes(
    result: Optional[Data] = Optional.Absent,
    scheduledEventId: EventId,
    startedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes = {
    import ActivityTaskCompletedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes
      .builder()
      .optionallyWith(
        result.map(value => Data.unwrap(value): java.lang.String)
      )(_.result)
      .scheduledEventId(EventId.unwrap(scheduledEventId): java.lang.Long)
      .startedEventId(EventId.unwrap(startedEventId): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly =
    zio.aws.swf.model.ActivityTaskCompletedEventAttributes.wrap(buildAwsValue())
}
object ActivityTaskCompletedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.ActivityTaskCompletedEventAttributes =
      zio.aws.swf.model.ActivityTaskCompletedEventAttributes(
        result.map(value => value),
        scheduledEventId,
        startedEventId
      )
    def result: Optional[Data]
    def scheduledEventId: EventId
    def startedEventId: EventId
    def getResult: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("result", result)
    def getScheduledEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(scheduledEventId)
    def getStartedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(startedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes
  ) extends zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly {
    override val result: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val scheduledEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.scheduledEventId())
    override val startedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.startedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes
  ): zio.aws.swf.model.ActivityTaskCompletedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
