package zio.aws.swf.model
import zio.aws.swf.model.primitives.{
  ReverseOrder,
  PageSize,
  PageToken,
  DomainName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetWorkflowExecutionHistoryRequest(
    domain: DomainName,
    execution: zio.aws.swf.model.WorkflowExecution,
    nextPageToken: Optional[PageToken] = Optional.Absent,
    maximumPageSize: Optional[PageSize] = Optional.Absent,
    reverseOrder: Optional[ReverseOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest = {
    import GetWorkflowExecutionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .execution(execution.buildAwsValue())
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        maximumPageSize.map(value => PageSize.unwrap(value): Integer)
      )(_.maximumPageSize)
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.GetWorkflowExecutionHistoryRequest.ReadOnly =
    zio.aws.swf.model.GetWorkflowExecutionHistoryRequest.wrap(buildAwsValue())
}
object GetWorkflowExecutionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.GetWorkflowExecutionHistoryRequest =
      zio.aws.swf.model.GetWorkflowExecutionHistoryRequest(
        domain,
        execution.asEditable,
        nextPageToken.map(value => value),
        maximumPageSize.map(value => value),
        reverseOrder.map(value => value)
      )
    def domain: DomainName
    def execution: zio.aws.swf.model.WorkflowExecution.ReadOnly
    def nextPageToken: Optional[PageToken]
    def maximumPageSize: Optional[PageSize]
    def reverseOrder: Optional[ReverseOrder]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getExecution
        : ZIO[Any, Nothing, zio.aws.swf.model.WorkflowExecution.ReadOnly] =
      ZIO.succeed(execution)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getMaximumPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maximumPageSize", maximumPageSize)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest
  ) extends zio.aws.swf.model.GetWorkflowExecutionHistoryRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.swf.model.primitives.DomainName(impl.domain())
    override val execution: zio.aws.swf.model.WorkflowExecution.ReadOnly =
      zio.aws.swf.model.WorkflowExecution.wrap(impl.execution())
    override val nextPageToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.swf.model.primitives.PageToken(value))
    override val maximumPageSize: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumPageSize())
      .map(value => zio.aws.swf.model.primitives.PageSize(value))
    override val reverseOrder: Optional[ReverseOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => zio.aws.swf.model.primitives.ReverseOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest
  ): zio.aws.swf.model.GetWorkflowExecutionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
