package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{EventId, Data, FailureReason}
import scala.jdk.CollectionConverters.*
final case class WorkflowExecutionFailedEventAttributes(
    reason: Optional[FailureReason] = Optional.Absent,
    details: Optional[Data] = Optional.Absent,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionFailedEventAttributes = {
    import WorkflowExecutionFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.WorkflowExecutionFailedEventAttributes
      .builder()
      .optionallyWith(
        reason.map(value => FailureReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => Data.unwrap(value): java.lang.String)
      )(_.details)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.WorkflowExecutionFailedEventAttributes
      .wrap(buildAwsValue())
}
object WorkflowExecutionFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.WorkflowExecutionFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.swf.model.WorkflowExecutionFailedEventAttributes =
      zio.aws.swf.model.WorkflowExecutionFailedEventAttributes(
        reason.map(value => value),
        details.map(value => value),
        decisionTaskCompletedEventId
      )
    def reason: Optional[FailureReason]
    def details: Optional[Data]
    def decisionTaskCompletedEventId: EventId
    def getReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("details", details)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionFailedEventAttributes
  ) extends zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly {
    override val reason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.swf.model.primitives.FailureReason(value))
    override val details: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.WorkflowExecutionFailedEventAttributes
  ): zio.aws.swf.model.WorkflowExecutionFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
