package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.swf.model.primitives.{
  TaskPriority,
  Data,
  Tag,
  Arn,
  Version,
  DurationInSecondsOptional
}
import scala.jdk.CollectionConverters.*
final case class ContinueAsNewWorkflowExecutionDecisionAttributes(
    input: Optional[Data] = Optional.Absent,
    executionStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    taskList: Optional[zio.aws.swf.model.TaskList] = Optional.Absent,
    taskPriority: Optional[TaskPriority] = Optional.Absent,
    taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      Optional.Absent,
    childPolicy: Optional[zio.aws.swf.model.ChildPolicy] = Optional.Absent,
    tagList: Optional[Iterable[Tag]] = Optional.Absent,
    workflowTypeVersion: Optional[Version] = Optional.Absent,
    lambdaRole: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes = {
    import ContinueAsNewWorkflowExecutionDecisionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
      .builder()
      .optionallyWith(input.map(value => Data.unwrap(value): java.lang.String))(
        _.input
      )
      .optionallyWith(
        executionStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.executionStartToCloseTimeout)
      .optionallyWith(taskList.map(value => value.buildAwsValue()))(_.taskList)
      .optionallyWith(
        taskPriority.map(value => TaskPriority.unwrap(value): java.lang.String)
      )(_.taskPriority)
      .optionallyWith(
        taskStartToCloseTimeout.map(value =>
          DurationInSecondsOptional.unwrap(value): java.lang.String
        )
      )(_.taskStartToCloseTimeout)
      .optionallyWith(childPolicy.map(value => value.unwrap))(_.childPolicy)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            Tag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(
        workflowTypeVersion.map(value =>
          Version.unwrap(value): java.lang.String
        )
      )(_.workflowTypeVersion)
      .optionallyWith(
        lambdaRole.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lambdaRole)
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly =
    zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
      .wrap(buildAwsValue())
}
object ContinueAsNewWorkflowExecutionDecisionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes =
      zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes(
        input.map(value => value),
        executionStartToCloseTimeout.map(value => value),
        taskList.map(value => value.asEditable),
        taskPriority.map(value => value),
        taskStartToCloseTimeout.map(value => value),
        childPolicy.map(value => value),
        tagList.map(value => value),
        workflowTypeVersion.map(value => value),
        lambdaRole.map(value => value)
      )
    def input: Optional[Data]
    def executionStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly]
    def taskPriority: Optional[TaskPriority]
    def taskStartToCloseTimeout: Optional[DurationInSecondsOptional]
    def childPolicy: Optional[zio.aws.swf.model.ChildPolicy]
    def tagList: Optional[List[Tag]]
    def workflowTypeVersion: Optional[Version]
    def lambdaRole: Optional[Arn]
    def getInput: ZIO[Any, AwsError, Data] =
      AwsError.unwrapOptionField("input", input)
    def getExecutionStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] =
      AwsError.unwrapOptionField(
        "executionStartToCloseTimeout",
        executionStartToCloseTimeout
      )
    def getTaskList: ZIO[Any, AwsError, zio.aws.swf.model.TaskList.ReadOnly] =
      AwsError.unwrapOptionField("taskList", taskList)
    def getTaskPriority: ZIO[Any, AwsError, TaskPriority] =
      AwsError.unwrapOptionField("taskPriority", taskPriority)
    def getTaskStartToCloseTimeout
        : ZIO[Any, AwsError, DurationInSecondsOptional] = AwsError
      .unwrapOptionField("taskStartToCloseTimeout", taskStartToCloseTimeout)
    def getChildPolicy: ZIO[Any, AwsError, zio.aws.swf.model.ChildPolicy] =
      AwsError.unwrapOptionField("childPolicy", childPolicy)
    def getTagList: ZIO[Any, AwsError, List[Tag]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getWorkflowTypeVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("workflowTypeVersion", workflowTypeVersion)
    def getLambdaRole: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lambdaRole", lambdaRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
  ) extends zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly {
    override val input: Optional[Data] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.swf.model.primitives.Data(value))
    override val executionStartToCloseTimeout
        : Optional[DurationInSecondsOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartToCloseTimeout())
      .map(value =>
        zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
      )
    override val taskList: Optional[zio.aws.swf.model.TaskList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskList())
        .map(value => zio.aws.swf.model.TaskList.wrap(value))
    override val taskPriority: Optional[TaskPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.taskPriority())
      .map(value => zio.aws.swf.model.primitives.TaskPriority(value))
    override val taskStartToCloseTimeout: Optional[DurationInSecondsOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskStartToCloseTimeout())
        .map(value =>
          zio.aws.swf.model.primitives.DurationInSecondsOptional(value)
        )
    override val childPolicy: Optional[zio.aws.swf.model.ChildPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childPolicy())
        .map(value => zio.aws.swf.model.ChildPolicy.wrap(value))
    override val tagList: Optional[List[Tag]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.swf.model.primitives.Tag(item)
        }.toList
      )
    override val workflowTypeVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowTypeVersion())
      .map(value => zio.aws.swf.model.primitives.Version(value))
    override val lambdaRole: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaRole())
      .map(value => zio.aws.swf.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes
  ): zio.aws.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes.ReadOnly =
    new Wrapper(impl)
}
