package zio.aws.swf.model
import scala.jdk.CollectionConverters.*
sealed trait WorkflowExecutionTimeoutType {
  def unwrap
      : software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType
}
object WorkflowExecutionTimeoutType {
  def wrap(
      value: software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType
  ): zio.aws.swf.model.WorkflowExecutionTimeoutType = value match {
    case software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType.START_TO_CLOSE =>
      val r = START_TO_CLOSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.swf.model.WorkflowExecutionTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType =
      software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType.UNKNOWN_TO_SDK_VERSION
  }
  case object START_TO_CLOSE
      extends zio.aws.swf.model.WorkflowExecutionTimeoutType {
    override def unwrap
        : software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType =
      software.amazon.awssdk.services.swf.model.WorkflowExecutionTimeoutType.START_TO_CLOSE
  }
}
