package zio.aws.swf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.swf.model.primitives.{EventId, ActivityId}
import scala.jdk.CollectionConverters.*
final case class ScheduleActivityTaskFailedEventAttributes(
    activityType: zio.aws.swf.model.ActivityType,
    activityId: ActivityId,
    cause: zio.aws.swf.model.ScheduleActivityTaskFailedCause,
    decisionTaskCompletedEventId: EventId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes = {
    import ScheduleActivityTaskFailedEventAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes
      .builder()
      .activityType(activityType.buildAwsValue())
      .activityId(ActivityId.unwrap(activityId): java.lang.String)
      .cause(cause.unwrap)
      .decisionTaskCompletedEventId(
        EventId.unwrap(decisionTaskCompletedEventId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly =
    zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes
      .wrap(buildAwsValue())
}
object ScheduleActivityTaskFailedEventAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes =
      zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes(
        activityType.asEditable,
        activityId,
        cause,
        decisionTaskCompletedEventId
      )
    def activityType: zio.aws.swf.model.ActivityType.ReadOnly
    def activityId: ActivityId
    def cause: zio.aws.swf.model.ScheduleActivityTaskFailedCause
    def decisionTaskCompletedEventId: EventId
    def getActivityType
        : ZIO[Any, Nothing, zio.aws.swf.model.ActivityType.ReadOnly] =
      ZIO.succeed(activityType)
    def getActivityId: ZIO[Any, Nothing, ActivityId] = ZIO.succeed(activityId)
    def getCause
        : ZIO[Any, Nothing, zio.aws.swf.model.ScheduleActivityTaskFailedCause] =
      ZIO.succeed(cause)
    def getDecisionTaskCompletedEventId: ZIO[Any, Nothing, EventId] =
      ZIO.succeed(decisionTaskCompletedEventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes
  ) extends zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly {
    override val activityType: zio.aws.swf.model.ActivityType.ReadOnly =
      zio.aws.swf.model.ActivityType.wrap(impl.activityType())
    override val activityId: ActivityId =
      zio.aws.swf.model.primitives.ActivityId(impl.activityId())
    override val cause: zio.aws.swf.model.ScheduleActivityTaskFailedCause =
      zio.aws.swf.model.ScheduleActivityTaskFailedCause.wrap(impl.cause())
    override val decisionTaskCompletedEventId: EventId =
      zio.aws.swf.model.primitives.EventId(impl.decisionTaskCompletedEventId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes
  ): zio.aws.swf.model.ScheduleActivityTaskFailedEventAttributes.ReadOnly =
    new Wrapper(impl)
}
